# SYMBIAN_UID = 0x1000052F#
# Lifeguide (C) 2007 Steve Litchfield

import appuifw
from appuifw import *
import e32
import os

from key_codes import *
from graphics import *
from akntextutils import wrap_text_to_array

version=u'1.1'
pathtoapp="E:\Lifeguide"

# menus used
L = [u"Bible says about", u"Seeking guidance", u"Needing help", u"You want to pray", u"About", u"exit"]

BT = [u"The Bible", u"Christ - His birth", u"Christ - His mission", u"Christ - His death", 
      u"Christ - His resurrection", u"Christ - His person", u"Christ - His return", u"Death", u"Devil",
      u"Eternal Life", u"Faith", u"Forgiveness", u"God", u"God's love", u"Heaven", u"Hell", u"Holy Spirit", 
      u"Human nature", u"Judgement", u"Life", u"Man", u"Mercy", u"Prayer", u"Repentance", u"Resurrection", 
      u"Salvation", u"Sin", u"Wisdom", u"You" ]

GT = [u"Anger", u"Citizenship",u"Conceit", u"Contentment" , u"Crime" , u"Death" , u"Friendship" , 
      u"Good character" , u"Greed" , u"Hatred" , u"Hope" , u"Humility", u"Love" , u"Marriage" ,
      u"Obedience" , u"Parents" , u"Patience" , u"Permissiveness" , u"Purity", u"Revenge" , u"Riches" ,
      u"Self control" , u"Thankfulness" , u"Thoughts" , u"Truthfulness"]

HT = [u"Afraid", u"Anxious or worried", u"Bereaved", u"Bitter or critical", u"Choosing a career", 
      u"Conscious of sin", u"Contemplating marriage", u"Dedicating your life", u"Depressed", 
      u"Doubting", u"Failure comes", u"Faith is weak", u"Feeling Inadequate", u"Friends fail", u"Ill or in pain", 
      u"In danger", u"Lonely", u"Needing Assurance", u"Needing Guidance", u"Needing Peace", u"Needing sleep", 
      u"Praying", u"Sad", u"Tempted", u"Wanting courage", u"Weary" ]

PT = [u"Reading the Bible", u"Conscious of sin", u"Needing comfort", u"In search of faith", 
      u"Seeking guidance", u"In praise of God", u"Commitment to God" ]


class Keyboard(object):
    def __init__(self,onevent=lambda:None):
        self._keyboard_state={}
        self._downs={}
        self._onevent=onevent
    def handle_event(self,event):
        if event['type'] == appuifw.EEventKeyDown:
            code=event['scancode']
            if not self.is_down(code):
                self._downs[code]=self._downs.get(code,0)+1
            self._keyboard_state[code]=1
        elif event['type'] == appuifw.EEventKeyUp:
            self._keyboard_state[event['scancode']]=0
        self._onevent()
    def is_down(self,scancode):
        return self._keyboard_state.get(scancode,0)
    def pressed(self,scancode):
        if self._downs.get(scancode,0):
            self._downs[scancode]-=1
            return True
        return False

keyboard=Keyboard()

def readtext():
# read in text arrays from file

    global bibletext
    global guidancetext
    global helptext
    global prayertext   

    file = open(pathtoapp+"\\bible.txt",'r')
    bibletext=file.readlines() 
    file.close
    
    file = open(pathtoapp+"\\guidance.txt",'r')
    guidancetext=file.readlines() 
    file.close
    
    file = open(pathtoapp+"\\help.txt",'r')
    helptext=file.readlines() 
    file.close
    
    file = open(pathtoapp+"\\prayer.txt",'r')
    prayertext=file.readlines() 
    file.close
       
def waitkey():
    running=1
    while running:
        if keyboard.pressed(EScancodeLeftArrow) or keyboard.pressed(EScancodeRightArrow) or keyboard.pressed(EScancodeDownArrow):
            running=0
            break
        elif keyboard.pressed(EScancodeUpArrow) or keyboard.pressed(EScancodeLeftSoftkey) or keyboard.pressed(EScancodeSelect):
            running=0
            break
    
        e32.ao_yield()


        
def text(long_str):
    lines = wrap_text_to_array(long_str, 'dense', 240)

    img.clear(0xefd9a9) # parchment colour!
    x, y = 2, 0
    for line in lines:
       y += 20
       img.text((x, y), line, font='dense')
       handle_redraw(())
       
    waitkey()


def bible():
    index = appuifw.popup_menu(BT)
    if index >=0:
        text(u" "+bibletext[index]) # leading space forces conversion of string to Unicode
    
def guidance():
    index = appuifw.popup_menu(GT)
    if index >=0:
        text(u" "+guidancetext[index])
    
def help():
    index = appuifw.popup_menu(HT)
    if index >=0:
        text(u" "+helptext[index]) 
    
def prayer():
    index = appuifw.popup_menu(PT)
    if index >=0:
        text(u" "+prayertext[index]) 
    
       

    
def exit_key_handler():
    appuifw.app.set_exit()
    
def quit():
    appuifw.app.set_exit()

def mainmenu():
    toplevel=1
    while toplevel:
        index = appuifw.popup_menu(L)
        if index == 0:
            bible()
        elif index == 1:
            guidance()
        elif index == 2:
            help()
        elif index == 3:
            prayer()
        elif index == 4:
            about()
        elif index == 5:
            toplevel=0
            quit()
            
    
        e32.ao_yield()      
    
        
def about():
    appuifw.note(u"Lifeguide v"+version+"\n(C) 2007 Steve Litchfield\nhttp://3lib.ukonline.co.uk/", "info")

def handle_redraw(rect):
    canvas.blit(img)
    e32.ao_yield()

canvas=appuifw.Canvas(event_callback=keyboard.handle_event, redraw_callback=handle_redraw)

appuifw.app.body=canvas

appuifw.app.title = u"Lifeguide"

appuifw.app.exit_key_handler = exit_key_handler
appuifw.app.screen='normal' #(a normal screen with title pane and softkeys)
img=Image.new((240,240))
# img.clear(0xefd9a9)  # parchment colour!
# handle_redraw(())

readtext()
appuifw.note(u"Lifeguide v"+version, "info")

mainmenu()
    
    
        
        
    




 

